using System;
class Program
{
    struct jarbol
    {
        public long x, h;
    }
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        string[] xsStr = Console.ReadLine().Split();
        string[] hsStr = Console.ReadLine().Split();
        jarbol[] a = new jarbol[n];
        for (int i = 0; i < n; i++)
        {
            a[i].x = long.Parse(xsStr[i]);
            a[i].h = long.Parse(hsStr[i]);
        }
        Array.Sort(a, (p, q) =>
        {
            if (p.x < q.x) return -1;
            if (p.x > q.x) return 1;
            return 0;
        });
        long[] xm = new long[n - 1];
        long[] ym = new long[n - 1];
        for (int i = 0; i < n - 1; i++)
        {
            xm[i] = (a[i].h - a[i + 1].h + a[i].x + a[i + 1].x) / 2;
            ym[i] = a[i].h - (xm[i] - a[i].x);
        }
        for (int i = 0; i < n; i++)
        {
            long najmanjehrastojanje = long.MaxValue;
            for (int j = i - 1; j <= i; j++)
            {
                if (j < 0 || j >= n - 1) continue;
                Check(a[i], a[j].x, a[j].h, xm[j], ym[j], ref najmanjehrastojanje);
                Check(a[i], xm[j], ym[j], a[j + 1].x, a[j + 1].h, ref najmanjehrastojanje);
            }
            Console.WriteLine(najmanjehrastojanje == long.MaxValue ? -1 : najmanjehrastojanje);
        }
    }
    static void Check(jarbol s, long x1, long y1, long x2, long y2, ref long najmanjehrastojanje)
    {
        if ((y1 < s.h && y2 < s.h) || (y1 > s.h && y2 > s.h))
            return;
        if (y1 == y2)
            return;
        long num = s.h - y1;
        long den = y2 - y1;
        if ((num < 0 && den > 0) || (num > 0 && den < 0))
            return;
        if (Math.Abs(num) > Math.Abs(den))
            return;
        long xi = x1 + (x2 - x1) * num / den;
        if (xi != s.x)
        {
            long hrastojanje = xi - s.x;
            if (hrastojanje < 0) hrastojanje = -hrastojanje;
            if (hrastojanje < najmanjehrastojanje) najmanjehrastojanje = hrastojanje;
        }
    }
}